//
//  ViewController.swift
//  FindPizza
//
//  Created by Krishna Subramanian on 22/12/15.
//  Copyright © 2015 Krishna Subramanian. All rights reserved.
//

import UIKit
import CoreLocation
import MapKit

class ViewController: UIViewController, MKMapViewDelegate {

  @IBOutlet weak var mapView: MKMapView!
  
  override func viewDidLoad() {
    super.viewDidLoad()
    
    // Setup mapView
    self.mapView.delegate = self
    self.mapView.mapType = MKMapType.Standard
    
    // Center the map to Informatik Zentrum
    let currentLocation = CLLocationCoordinate2DMake(50.779393, 6.059171)
    self.mapView.setRegion(MKCoordinateRegion(center: currentLocation, span: MKCoordinateSpanMake(0.5, 0.5)), animated: true)
  }
  
  @IBAction func findPizza(sender: AnyObject) {
    // Make a request object
    let request = MKLocalSearchRequest()
    request.naturalLanguageQuery = "Pizza"
    request.region = self.mapView.region
    
    // Make a search object
    let search = MKLocalSearch(request: request)
    
    // Search and handle the response 
    search.startWithCompletionHandler({
      (response, error) in
      var placemarks = [MKPlacemark]()
      
      for item in (response?.mapItems)! {
        placemarks.append(item.placemark)
      }
      
      // Display the annotations
      self.mapView.showAnnotations(placemarks, animated: true)
    })
  }
  
  override func didReceiveMemoryWarning() {
    super.didReceiveMemoryWarning()
    // Dispose of any resources that can be recreated.
  }


}

